--# UI2D
UI2D = class()

function UI2D:init(board, renderer)
    self.board = board
    self.renderer = renderer
end

function UI2D:moveCandidateTo(q,r)
    self.board:moveCandidateTo(q,r)
end

function UI2D:playableHexTapped(touch)
    if touch.state ~= ENDED then return end
    
    local plays = self.board:playableHexes()
    
    for _,h in ipairs(plays) do
        local p = self.renderer:axialToPixel(h.q, h.r)
        
        local dx = touch.x - p.x
        local dy = touch.y - p.y
        
        if dx*dx + dy*dy < (self.renderer.size*0.8)^2 then
            return h.q, h.r
        end
    end
end

function UI2D:countCandidateMatches()
    return self.board:countCandidateMatches()
end

function UI2D:drawMatchCount()
    local cand
    
    for _,cell in ipairs(self.board:allHexCellsAsFlatList()) do
        if cell.tile and cell.tile.kind == "candidate" then
            cand = cell
            break
        end
    end
    
    if not cand then return end
    
    local p = self.renderer:axialToPixel(cand.q, cand.r)
    local n = self:countCandidateMatches()
    
    pushStyle()
    textAlign(CENTER)
    fontSize(36)
    fill(255)
    text(n, p.x, p.y)
    popStyle()
end

function UI2D:candidateTapped(touch)
    if touch.state ~= ENDED then return end
    print("tapped")
    for _,cell in ipairs(self.board:allHexCellsAsFlatList()) do
        if cell.tile and cell.tile.kind == "candidate" then
            local p = self.renderer:axialToPixel(cell.q, cell.r)
            
            local dx = touch.x - p.x
            local dy = touch.y - p.y
            
            if dx*dx + dy*dy < (self.renderer.size*0.8)^2 then
                return cell.q, cell.r
            end
            
            break
        end
    end
end